/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.service.impl;

import com.teswell.common.base.BaseService;
import com.teswell.mapper.FtpConfigMapper;
import com.teswell.mapper.FtpStateMapper;
import com.teswell.model.FtpConfig;
import com.teswell.model.FtpState;
import com.teswell.model.MonitorVo;
import com.teswell.service.FtpStateService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRED, readOnly=true, rollbackFor={Exception.class})
public class FtpStateServiceImpl
extends BaseService<FtpState>
implements FtpStateService {
    private static final Logger log = LoggerFactory.getLogger(FtpStateServiceImpl.class);
    @Resource
    FtpStateMapper stateMapper;
    @Autowired
    FtpConfigMapper ftpConfigMapper;

    public List<MonitorVo> selectDownFileList(String carLicense, String state, String startTime, String endTime) {
        List selectDownFileList = null;
        try {
            selectDownFileList = this.stateMapper.selectDownFileList(carLicense, state, startTime, endTime);
        }
        catch (Exception e) {
            log.error("========>" + e.getMessage());
        }
        return selectDownFileList;
    }

    public List<MonitorVo> selectDownFileList(Map<String, Object> paramMap) {
        List selectDownFileList = this.stateMapper.selectDownFileList(paramMap);
        for (MonitorVo monitorVo : selectDownFileList) {
            try {
                this.setFtpDownLoadFilePathAndFtpUrl(monitorVo);
            }
            catch (Exception e) {
                log.error("ftpUrl\u8d4b\u503c\u9519\u8bef");
            }
        }
        return selectDownFileList;
    }

    public void setFtpDownLoadFilePathAndFtpUrl(MonitorVo entity) {
        FtpConfig ftpConfig = (FtpConfig)this.ftpConfigMapper.selectByPrimaryKey((Object)String.valueOf(entity.getFtpId()));
        StringBuilder url = new StringBuilder();
        StringBuilder ftpUrl = new StringBuilder();
        if (ftpConfig != null) {
            url.append("ftp://").append(ftpConfig.getFtpName()).append(":").append(ftpConfig.getFtpPassword()).append("@").append(ftpConfig.getFtpIp()).append(":").append(ftpConfig.getFtpProt()).append(entity.getDownPath());
            entity.setDownPath(url.toString());
            ftpUrl.append("ftp://").append(ftpConfig.getFtpIp()).append(":").append(ftpConfig.getFtpProt());
            entity.setFtpUrl(ftpUrl.toString());
        }
    }

    public String getFtpDownLoadFilePath(String fileId, String ftpId, String filePath) {
        FtpConfig ftpConfig = (FtpConfig)this.ftpConfigMapper.selectByPrimaryKey((Object)ftpId);
        StringBuilder url = new StringBuilder();
        if (ftpConfig != null) {
            url.append("ftp://").append(ftpConfig.getFtpName()).append(":").append(ftpConfig.getFtpPassword()).append("@").append(ftpConfig.getFtpIp()).append(":").append(ftpConfig.getFtpProt()).append(filePath);
            return url.toString();
        }
        return null;
    }
}

