/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.controller.api;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.teswell.common.base.BaseController;
import com.teswell.common.model.PageResult;
import com.teswell.service.DeviceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vehicle"})
@CrossOrigin(origins={"*"})
@Api(tags={"\u8f66\u8f86\u7ba1\u7406\u63a5\u53e3"})
public class VehicleController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(VehicleController.class);
    @Autowired
    DeviceService deviceService;

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u672a\u672a\u5206\u914d\u8f66\u8f86")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Map<String, Object> vehicleList(HttpServletRequest request, HttpServletResponse response, PageResult page, @RequestParam Map<String, Object> paramMap) {
        try {
            PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
            String vehicleLensece = "";
            if (paramMap.get("vehicleLensece") != null) {
                vehicleLensece = String.valueOf(paramMap.get("vehicleLensece"));
            }
            List unallocatedDeviceList = this.deviceService.getUnallocatedDeviceList(vehicleLensece);
            PageInfo info = new PageInfo(unallocatedDeviceList);
            return this.returnDataTable(info);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("vehicleList" + e.getMessage());
            return null;
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u672a\u5df2\u5206\u914d\u8f66\u8f86{ftpId}")
    @RequestMapping(value={"/getVehicle"}, method={RequestMethod.GET})
    public Map<String, Object> getVehicle(HttpServletRequest request, HttpServletResponse response, PageResult page, @RequestParam String id) {
        PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
        try {
            if (!StringUtils.isEmpty((Object)id)) {
                List allocatedDeviceList = this.deviceService.getAllocatedDeviceList(id);
                PageInfo info = new PageInfo(allocatedDeviceList);
                return this.returnDataTable(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("vehicleList" + e.getMessage());
        }
        return null;
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u8f66\u8f86")
    @RequestMapping(value={"/allVehicleList"}, method={RequestMethod.GET})
    public Map<String, Object> allVehicleList(HttpServletRequest request, HttpServletResponse response, PageResult page, @RequestParam Map<String, Object> paramMap) {
        try {
            PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
            List unallocatedDeviceList = this.deviceService.getVehicleList(paramMap);
            PageInfo info = new PageInfo(unallocatedDeviceList);
            return this.returnDataTable(info);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("allVehicleList" + e.getMessage());
            return null;
        }
    }
}

