/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.controller.api;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.teswell.common.base.BaseController;
import com.teswell.common.enums.StatusCode;
import com.teswell.common.model.PageResult;
import com.teswell.common.model.ResponseResult;
import com.teswell.model.FtpTactics;
import com.teswell.service.FtpTacticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/ftpTactics"})
@CrossOrigin(origins={"*"})
@Api(tags={"\u7b56\u7565\u76f8\u5173\u63a5\u53e3"}, description="\u63d0\u4f9b\u7b56\u7565\u76f8\u5173\u7684 Rest API")
public class FtpTacticsController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FtpTacticsController.class);
    @Autowired
    FtpTacticsService tacticsService;

    @ResponseBody
    @ApiOperation(value="\u7b56\u7565\u540d\u662f\u5426\u5df2\u5b58\u5728 true")
    @RequestMapping(value={"/checkName"}, method={RequestMethod.GET})
    public Map<String, Object> checkTactics(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        boolean flag = true;
        try {
            if (this.requiredParam(paramMap, "tacticsName")) {
                Example example = new Example(FtpTactics.class);
                example.createCriteria().andCondition("tactics_name = ", (Object)String.valueOf(paramMap.get("tacticsName")));
                List selectByExample = this.tacticsService.selectByExample((Object)example);
                if (selectByExample != null && selectByExample.size() > 0) {
                    flag = false;
                }
            }
        }
        catch (Exception e) {
            log.error("addFtpTactics" + e.getMessage());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("valid", flag);
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6dfb\u52a0\u7b56\u7565")
    public ResponseResult addFtpTactics(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        String[] filed = new String[]{"tacticsName", "ch", "netType", "fileType", "ftpId", "executeState"};
        try {
            if (this.requiredParam(paramMap, filed)) {
                FtpTactics ftpTactics = new FtpTactics();
                ftpTactics.setTacticsName(String.valueOf(paramMap.get("tacticsName")));
                ftpTactics.setCh(String.valueOf(paramMap.get("ch")));
                ftpTactics.setNetType(String.valueOf(paramMap.get("netType")));
                ftpTactics.setFileType(String.valueOf(paramMap.get("fileType")));
                ftpTactics.setFtpId(String.valueOf(paramMap.get("ftpId")));
                ftpTactics.setExecuteState(String.valueOf(paramMap.get("executeState")));
                if (paramMap.get("getInStationTime") != null) {
                    ftpTactics.setGetInStationTime(String.valueOf(paramMap.get("getInStationTime")));
                }
                if (paramMap.get("dayDownTimeEnd1") != null) {
                    ftpTactics.setDayDownTimeEnd1(String.valueOf(paramMap.get("dayDownTimeEnd1")));
                }
                if (paramMap.get("dayDownTimeEnd2") != null) {
                    ftpTactics.setDayDownTimeEnd2(String.valueOf(paramMap.get("dayDownTimeEnd2")));
                }
                if (paramMap.get("dayDownTimeStart1") != null) {
                    ftpTactics.setDayDownTimeStart1(String.valueOf(paramMap.get("dayDownTimeStart1")));
                }
                if (paramMap.get("dayDownTimeStart2") != null) {
                    ftpTactics.setDayDownTimeStart2(String.valueOf(paramMap.get("dayDownTimeStart2")));
                }
                if (paramMap.get("appointDateStart") != null) {
                    ftpTactics.setAppointDateStart(String.valueOf(paramMap.get("appointDateStart")));
                }
                if (paramMap.get("appointDateEnd") != null) {
                    ftpTactics.setAppointDateEnd(String.valueOf(paramMap.get("appointDateEnd")));
                }
                if (paramMap.get("startTime") != null) {
                    ftpTactics.setStartTime(String.valueOf(paramMap.get("startTime")));
                }
                if (paramMap.get("endTime") != null) {
                    ftpTactics.setEndTime(String.valueOf(paramMap.get("endTime")));
                }
                ftpTactics.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                if (paramMap.get("updateTime") != null) {
                    ftpTactics.setUpdateTime(String.valueOf(paramMap.get("updateTime")));
                }
                ftpTactics.setTacticsFlag(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("tacticsFlag")))));
                int save = this.tacticsService.save((Object)ftpTactics);
                if (save > 0) {
                    return ResponseResult.getSuccessResult((Object)"\u4fdd\u5b58\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("addFtpTactics" + e.getMessage());
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u65b0\u589e\u5931\u8d25");
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7b56\u7565")
    @RequestMapping(value={"/selectOne"}, method={RequestMethod.GET})
    public ResponseResult getFtpTactics(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            FtpTactics ftpTactics;
            if (this.requiredParam(paramMap, "id") && (ftpTactics = (FtpTactics)this.tacticsService.selectByKey((Object)String.valueOf(paramMap.get("id")))) != null) {
                return ResponseResult.getSuccessResult((Object)ftpTactics);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("select One Tactics" + e.getMessage());
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u67e5\u8be2\u5931\u8d25");
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u7b56\u7565\u96c6\u5408")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Map<String, Object> getFtpTacticsList(HttpServletRequest request, HttpServletResponse response, PageResult page, @RequestParam Map<String, Object> paramMap) {
        try {
            PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
            List ftpTacticsList = this.tacticsService.findFtpTactics();
            PageInfo pageInfo = new PageInfo(ftpTacticsList);
            return this.returnDataTable(pageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("select One Tactics" + e.getMessage());
            return null;
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u7b56\u7565")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseResult deleteFtpTactics(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            int delete;
            if (this.requiredParam(paramMap, "id") && (delete = this.tacticsService.delete((Object)String.valueOf(paramMap.get("id")))) > 0) {
                return ResponseResult.getSuccessResult((Object)"\u5220\u9664\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("select One Tactics" + e.getMessage());
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u5220\u9664\u5931\u8d25");
    }

    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0\u7b56\u7565")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseResult updateFtpTactics(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            if (this.requiredParam(paramMap, "id")) {
                int updateNotNull;
                FtpTactics ftpTactics = new FtpTactics();
                ftpTactics.setId((Object)Integer.parseInt(String.valueOf(paramMap.get("id"))));
                ftpTactics.setFtpId(null);
                ftpTactics.setTacticsName(null);
                ftpTactics.setCh(String.valueOf(paramMap.get("ch")));
                ftpTactics.setNetType(String.valueOf(paramMap.get("netType")));
                ftpTactics.setFileType(String.valueOf(paramMap.get("fileType")));
                ftpTactics.setExecuteState(String.valueOf(paramMap.get("executeState")));
                ftpTactics.setTacticsFlag(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("tacticsFlag")))));
                if (paramMap.get("getInStationTime") != null) {
                    ftpTactics.setGetInStationTime(String.valueOf(paramMap.get("getInStationTime")));
                }
                if (paramMap.get("dayDownTimeEnd1") != null) {
                    ftpTactics.setDayDownTimeEnd1(String.valueOf(paramMap.get("dayDownTimeEnd1")));
                }
                if (paramMap.get("dayDownTimeEnd2") != null) {
                    ftpTactics.setDayDownTimeEnd2(String.valueOf(paramMap.get("dayDownTimeEnd2")));
                }
                if (paramMap.get("dayDownTimeStart1") != null) {
                    ftpTactics.setDayDownTimeStart1(String.valueOf(paramMap.get("dayDownTimeStart1")));
                }
                if (paramMap.get("dayDownTimeStart2") != null) {
                    ftpTactics.setDayDownTimeStart2(String.valueOf(paramMap.get("dayDownTimeStart2")));
                }
                if (paramMap.get("appointDateStart") != null) {
                    ftpTactics.setAppointDateStart(String.valueOf(paramMap.get("appointDateStart")));
                }
                if (paramMap.get("appointDateEnd") != null) {
                    ftpTactics.setAppointDateEnd(String.valueOf(paramMap.get("appointDateEnd")));
                }
                if (paramMap.get("startTime") != null) {
                    ftpTactics.setStartTime(String.valueOf(paramMap.get("startTime")));
                }
                if (paramMap.get("endTime") != null) {
                    ftpTactics.setEndTime(String.valueOf(paramMap.get("endTime")));
                }
                if (paramMap.get("getInStationTime") != null) {
                    ftpTactics.setGetInStationTime(String.valueOf(paramMap.get("getInStationTime")));
                }
                if ((updateNotNull = this.tacticsService.updateNotNull((Object)ftpTactics)) > 0) {
                    return ResponseResult.getSuccessResult((Object)"\u66f4\u65b0\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("update Tactics" + e.getMessage());
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u66f4\u65b0\u5931\u8d25");
    }
}

