/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.controller.api;

import com.teswell.common.base.BaseController;
import com.teswell.common.enums.StatusCode;
import com.teswell.common.model.ResponseResult;
import com.teswell.model.FtpDevconfig;
import com.teswell.service.FtpDevconfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/deviceFtp"})
@Api(tags={"FTP\u7ad9\u70b9\u5206\u914d\u8f66\u8f86\u76f8\u5173\u63a5\u53e3"}, description="\u63d0\u4f9b\u7ad9\u70b9\u8f66\u8f86\u7ba1\u7406\u76f8\u5173\u7684 Rest API")
public class FtpDevconfigController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FtpDevconfigController.class);
    @Autowired
    FtpDevconfigService devconfigService;

    @ApiOperation(value="\u4e3aftp\u7ad9\u70b9\u6dfb\u52a0\u8f66\u8f86")
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseResult addFtpDevconfig(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        block7: {
            try {
                String[] fildes = new String[]{"ftpId", "ids"};
                if (this.requiredParam(paramMap, fildes)) {
                    ArrayList<FtpDevconfig> ftpDevConfigList = new ArrayList<FtpDevconfig>();
                    String[] split = String.valueOf(paramMap.get("ids")).split(",");
                    List ftpDevconfigListByDevIds = this.devconfigService.getFtpDevconfigListByDevIds(Arrays.asList(split));
                    if (ftpDevconfigListByDevIds.size() > 0) {
                        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u9009\u62e9\u7684\u8f66\u8f86\u5df2\u7ecf\u5206\u914d");
                    }
                    for (String devId : split) {
                        FtpDevconfig config = new FtpDevconfig();
                        config.setDevId(devId);
                        config.setFtpConfigId(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("ftpId")))));
                        ftpDevConfigList.add(config);
                    }
                    if (ftpDevConfigList.size() > 0) {
                        for (FtpDevconfig bean : ftpDevConfigList) {
                            this.devconfigService.save((Object)bean);
                        }
                        return ResponseResult.getSuccessResult((Object)"\u6dfb\u52a0\u6210\u529f");
                    }
                    break block7;
                }
                return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_PARAM_EMPTY), (String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (Exception e) {
                log.error("addFtpDevconfig:" + e.getMessage());
                ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_CALL_API), (String)"\u8c03\u7528\u63a5\u53e3\u9519\u8bef");
            }
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u6dfb\u52a0\u5931\u8d25");
    }

    @ApiOperation(value="\u5220\u9664ftp\u7ad9\u70b9\u8f66\u8f86")
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseResult deleteDevconfig(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            if (this.requiredParam(paramMap, "ids")) {
                String[] split = String.valueOf(paramMap.get("ids")).split(",");
                List<String> idList = Arrays.asList(split);
                int batchDelete = this.devconfigService.batchDelete(idList, "devId", FtpDevconfig.class);
                if (batchDelete > 0) {
                    return ResponseResult.getSuccessResult((Object)"\u5220\u9664\u6210\u529f");
                }
                return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u5220\u9664\u5931\u8d25");
            }
            return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_PARAM_EMPTY), (String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            log.error("deleteFtpDevconfig:" + e.getMessage());
            return ResponseResult.getSuccessResult((Object)"\u5220\u9664\u6210\u529f");
        }
    }
}

