/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.controller.api;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.teswell.common.base.BaseController;
import com.teswell.common.enums.StatusCode;
import com.teswell.common.model.PageResult;
import com.teswell.common.model.ResponseResult;
import com.teswell.model.FtpConfig;
import com.teswell.model.FtpDevconfig;
import com.teswell.service.FtpConfigService;
import com.teswell.service.FtpDevconfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.PathParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/ftpConfig"})
@Api(tags={"FTP\u7ad9\u70b9\u914d\u7f6e\u76f8\u5173\u63a5\u53e3"})
public class FtpConfigController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FtpConfigController.class);
    @Autowired
    FtpConfigService configService;
    @Autowired
    FtpDevconfigService devconfigService;

    @ApiOperation(value="\u65b0\u589eFTP\u7ad9\u70b9\u914d\u7f6e")
    @ResponseBody
    @RequestMapping(value={"/insert"}, method={RequestMethod.POST})
    public ResponseResult add(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        block14: {
            String[] fileds = new String[]{"ftpIp", "ftpIpIn", "ftpProt", "ftpName", "ftpDes", "ftpProtIn", "ftpPassword"};
            try {
                if (this.requiredParam(paramMap, "ftpDes")) {
                    Example example = new Example(FtpConfig.class);
                    Example.Criteria createCriteria = example.createCriteria();
                    createCriteria.andCondition("ftp_des = ", (Object)String.valueOf(paramMap.get("ftpDes")));
                    List selectByExample = null;
                    try {
                        selectByExample = this.configService.selectByExample((Object)example);
                    }
                    catch (Exception e) {
                        log.error("===========>" + e.getMessage());
                        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_CALL_API), (String)"\u7cfb\u7edf\u9519\u8bef");
                    }
                    if (selectByExample != null && selectByExample.size() > 0) {
                        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_OTHER), (String)"\u670d\u52a1\u5668\u540d\u79f0\u91cd\u590d");
                    }
                }
                if (this.requiredParam(paramMap, fileds)) {
                    FtpConfig config = new FtpConfig();
                    config.setFtpIp(String.valueOf(paramMap.get("ftpIp")));
                    config.setFtpIpIn(String.valueOf(paramMap.get("ftpIpIn")));
                    config.setFtpProt(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("ftpProt")))));
                    config.setFtpProtIn(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("ftpProtIn")))));
                    config.setFtpName(String.valueOf(paramMap.get("ftpName")));
                    config.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    config.setFtpPassword(String.valueOf(paramMap.get("ftpPassword")));
                    config.setFtpDes(String.valueOf(paramMap.get("ftpDes")));
                    if (this.requiredParam(paramMap, "reserveDisk")) {
                        config.setReserveDisk(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("reserveDisk")))));
                    } else {
                        config.setReserveDisk(Integer.valueOf(1));
                    }
                    if (this.requiredParam(paramMap, "notEnoughTactics")) {
                        config.setNotEnoughTactics(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("notEnoughTactics")))));
                    } else {
                        config.setNotEnoughTactics(Integer.valueOf(0));
                    }
                    if (this.requiredParam(paramMap, "fileNum")) {
                        config.setFileNum(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("fileNum")))));
                    } else {
                        config.setFileNum(Integer.valueOf(10));
                    }
                    int save = this.configService.save((Object)config);
                    if (save > 0) {
                        return ResponseResult.getSuccessResult((Object)"\u6dfb\u52a0\u6210\u529f");
                    }
                    break block14;
                }
                return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_PARAM_EMPTY), (String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("=====>" + e.getMessage());
            }
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_CALL_API), (String)"\u975e\u6cd5\u53c2\u6570");
    }

    @ApiOperation(value="\u7ad9\u70b9\u540d\u67e5\u91cd")
    @ResponseBody
    @RequestMapping(value={"/checkFtpName"}, method={RequestMethod.GET})
    public HashMap<String, Object> checkOnlyOne(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        HashMap<String, Object> map;
        boolean flag;
        block5: {
            flag = true;
            map = new HashMap<String, Object>();
            try {
                if (!this.requiredParam(paramMap, "ftpDes")) break block5;
                Example example = new Example(FtpConfig.class);
                Example.Criteria createCriteria = example.createCriteria();
                createCriteria.andCondition("ftp_des = ", (Object)String.valueOf(paramMap.get("ftpDes")));
                List selectByExample = null;
                try {
                    selectByExample = this.configService.selectByExample((Object)example);
                }
                catch (Exception e) {
                    log.error("===========>" + e.getMessage());
                }
                if (selectByExample != null && selectByExample.size() > 0) {
                    flag = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("checkOnlyOne:" + e.getMessage());
                return map;
            }
        }
        map.put("valid", flag);
        return map;
    }

    @ApiOperation(value="\u66f4\u65b0FTP\u7ad9\u70b9\u914d\u7f6e", notes="\u5fc5\u586b\u9879 \uff1a \"id\",\"ftpIp\",\"ftpIpIn\",\"ftpProt\",\"ftpProtIn\",\"ftpPassword\"")
    @ResponseBody
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseResult updateFtpConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            String[] fileds = new String[]{"id", "ftpIp", "ftpIpIn", "ftpProt", "ftpProtIn", "ftpPassword"};
            FtpConfig config = new FtpConfig();
            if (this.requiredParam(paramMap, fileds)) {
                config.setId((Object)Integer.parseInt(String.valueOf(paramMap.get("id"))));
                config.setFtpIp(String.valueOf(paramMap.get("ftpIp")));
                config.setFtpName(String.valueOf(paramMap.get("ftpName")));
                config.setFtpIpIn(String.valueOf(paramMap.get("ftpIpIn")));
                config.setFtpProt(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("ftpProt")))));
                config.setFtpProtIn(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("ftpProtIn")))));
                config.setFtpPassword(String.valueOf(paramMap.get("ftpPassword")));
                int updateNotNull = this.configService.updateNotNull((Object)config);
                if (updateNotNull > 0) {
                    return ResponseResult.getSuccessResult((Object)"\u4fee\u6539\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            log.error("update FTP error :" + e.getMessage());
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u4fee\u6539\u5931\u8d25");
    }

    @ApiOperation(value="\u78c1\u76d8\u7ba1\u7406")
    @ResponseBody
    @RequestMapping(value={"/updateDisk"}, method={RequestMethod.POST})
    public ResponseResult updateDisk(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            String[] fileds = new String[]{"id", "reserveDisk", "notEnoughTactics", "fileNum"};
            FtpConfig config = new FtpConfig();
            if (this.requiredParam(paramMap, fileds)) {
                config.setId((Object)Integer.parseInt(String.valueOf(paramMap.get("id"))));
                config.setReserveDisk(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("reserveDisk")))));
                config.setNotEnoughTactics(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("notEnoughTactics")))));
                config.setFileNum(Integer.valueOf(Integer.parseInt(String.valueOf(paramMap.get("fileNum")))));
                int updateNotNull = this.configService.updateNotNull((Object)config);
                if (updateNotNull > 0) {
                    return ResponseResult.getSuccessResult((Object)"\u4fee\u6539\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            log.error("update FTP error :" + e.getMessage());
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u4fee\u6539\u5931\u8d25");
    }

    @ApiOperation(value="\u5220\u9664FTP\u7ad9\u70b9\u914d\u7f6e")
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseResult deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        block5: {
            try {
                if (this.requiredParam(paramMap, "id")) {
                    int delete = this.configService.delete((Object)Integer.parseInt(String.valueOf(paramMap.get("id"))));
                    if (delete > 0) {
                        return ResponseResult.getSuccessResult((Object)"\u5220\u9664\u6210\u529f");
                    }
                    break block5;
                }
                return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR_PARAM_EMPTY), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                log.error("===" + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("===" + e.getMessage());
            }
        }
        return ResponseResult.getErrorResult((String)String.valueOf(StatusCode.ERROR), (String)"\u5220\u9664\u5931\u8d25");
    }

    @ApiOperation(value="FTP\u7ad9\u70b9\u5217\u8868")
    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Map<String, Object> ftpConfigList(HttpServletRequest request, PageResult page, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        try {
            PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize());
            List selectAll = this.configService.selectAll();
            PageInfo info = new PageInfo(selectAll);
            return this.returnDataTable(info);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            log.error("===" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("===" + e.getMessage());
        }
        return null;
    }

    @ApiOperation(value="\u672a\u5206\u914d\u7b56\u7565FTP\u7ad9\u70b9\u5217\u8868")
    @ResponseBody
    @RequestMapping(value={"/unbindList"}, method={RequestMethod.GET})
    public ResponseResult ftpConfigList(HttpServletRequest request, PageResult page, HttpServletResponse response) {
        try {
            List selectAll = this.configService.selectUndistribuitedFtpConfig();
            return ResponseResult.getSuccessResult((Object)selectAll);
        }
        catch (Exception e) {
            log.error("===" + e.getMessage());
            return null;
        }
    }

    @ApiOperation(value="\u83b7\u53d6FTP\u7ad9\u70b9\u8f66\u8f86")
    @ResponseBody
    @RequestMapping(value={"/ftpDevice/{id}"}, method={RequestMethod.GET})
    public ResponseResult devConfig(HttpServletRequest request, HttpServletResponse response, @PathParam(value="id") String id) {
        Example example = new Example(FtpDevconfig.class);
        Example.Criteria createCriteria = example.createCriteria();
        createCriteria.andCondition("ftp_config_id = ", (Object)id);
        List list = this.devconfigService.selectByExample((Object)example);
        PageInfo pageInfo = new PageInfo(list);
        return ResponseResult.getSuccessResult((Object)this.returnDataTable(pageInfo));
    }
}

