/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.common.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pagination<T> {
    public static final int DEFAULT_PAGE = 1;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private List<T> items;
    private Map<String, Object> paramsMap;
    private long total = 0L;
    private int offset = 1;
    private int pageSize = 20;
    private int pageIndex = 1;
    private int page = 1;
    private int pageNumber = 1;
    private int rows = 20;
    private int startIndex = 0;
    private int endIndex = 0;
    private String orderDirection = "desc";
    private String orderField;

    public Pagination() {
        this(20, 1);
    }

    public Pagination(int pageSize, int pageIndex) {
        if (this.pageSize < 1) {
            this.pageSize = 20;
        } else if (this.pageIndex < 1) {
            this.pageIndex = 1;
        } else {
            this.pageSize = pageSize;
            this.pageIndex = pageIndex;
        }
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public Map<String, Object> getParamsMap() {
        return this.paramsMap;
    }

    public void setParamsMap(Map<String, Object> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getStartIndex() {
        this.startIndex = (this.pageIndex - 1) * this.pageSize;
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        this.endIndex = this.pageIndex * this.pageSize;
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public String getOrderDirection() {
        return this.orderDirection;
    }

    public void setOrderDirection(String orderDirection) {
        this.orderDirection = orderDirection;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Map<String, Object> getPageInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("total", this.getTotal());
        map.put("rows", this.getItems());
        return map;
    }
}

