/*
 * Decompiled with CFR 0.152.
 */
package com.teswell.common.base;

import com.teswell.common.base.IService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.common.Mapper;
import tk.mybatis.mapper.entity.Example;

@Service(value="baseService")
@Transactional(propagation=Propagation.REQUIRED, readOnly=true, rollbackFor={Exception.class})
public abstract class BaseService<T>
implements IService<T> {
    @Autowired
    protected Mapper<T> mapper;

    public Mapper<T> getMapper() {
        return this.mapper;
    }

    public List<T> selectAll() {
        return this.mapper.selectAll();
    }

    public T selectByKey(Object key) {
        return (T)this.mapper.selectByPrimaryKey(key);
    }

    @Transactional
    public int save(T entity) throws Exception {
        return this.mapper.insert(entity);
    }

    @Transactional
    public int delete(Object key) throws Exception {
        return this.mapper.deleteByPrimaryKey(key);
    }

    @Transactional
    public int batchDelete(List<String> list, String property, Class<T> clazz) throws Exception {
        Example example = new Example(clazz);
        example.createCriteria().andIn(property, list);
        return this.mapper.deleteByExample((Object)example);
    }

    @Transactional
    public int updateAll(T entity) throws Exception {
        return this.mapper.updateByPrimaryKey(entity);
    }

    @Transactional
    public int updateNotNull(T entity) throws Exception {
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    public List<T> selectByExample(Object example) {
        return this.mapper.selectByExample(example);
    }
}

